/*
 * Decompiled with CFR 0.152.
 */
package brm;

import brm.Console;
import javax.microedition.rms.RecordStore;

public class Settings {
    protected static final String storageName = "brmBtStore";
    protected static Settings instance = null;
    public String lastConnection = "";
    public int autoDisconnect = 30;
    public boolean forceBacklight = false;
    public String lastProfile = "";

    protected Settings() {
        this.load();
    }

    public static Settings instance() {
        if (instance == null) {
            instance = new Settings();
        }
        return instance;
    }

    public static String[] explodeString(String str, String delimiter) {
        int count;
        String[] values = new String[]{"", "", "", "", "", "", "", "", "", ""};
        int index = str.indexOf(delimiter);
        for (count = 0; index >= 0 && count < values.length; ++count) {
            values[count] = str.substring(0, index);
            str = str.substring(index + delimiter.length());
            index = str.indexOf(delimiter);
        }
        if (str.length() > 0 && count < values.length) {
            values[count] = str;
        }
        return values;
    }

    public boolean load() {
        String cfg;
        try {
            RecordStore rs = RecordStore.openRecordStore((String)storageName, (boolean)true);
            if (rs.getNumRecords() == 0) {
                Console.instance().log("No settings loaded, using defaults");
                rs.closeRecordStore();
                return false;
            }
            byte[] b = rs.getRecord(1);
            cfg = new String(b, 0, b.length);
            rs.closeRecordStore();
        }
        catch (Exception e) {
            return false;
        }
        Console.instance().log("Loaded settings: " + cfg);
        String[] values = Settings.explodeString(cfg, "|||");
        this.lastConnection = values[0];
        this.autoDisconnect = Integer.parseInt(values[1]);
        this.forceBacklight = Integer.parseInt(values[2]) > 0;
        this.lastProfile = values[3];
        return true;
    }

    public boolean save() {
        byte[] cfg = (this.lastConnection + "|||" + this.autoDisconnect + "|||" + (this.forceBacklight ? 1 : 0) + "|||" + this.lastProfile).getBytes();
        try {
            RecordStore.deleteRecordStore((String)storageName);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            RecordStore rs = RecordStore.openRecordStore((String)storageName, (boolean)true);
            rs.addRecord(cfg, 0, cfg.length);
            rs.closeRecordStore();
        }
        catch (Exception e) {
            return false;
        }
        Console.instance().log("Settings saved!");
        return true;
    }
}

