/*
 * Decompiled with CFR 0.152.
 */
package brm;

import brm.BluetoothMIDlet;
import brm.Communicator;
import brm.Console;
import brm.Settings;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;

public class DeviceList
implements CommandListener,
DiscoveryListener {
    protected Console console = Console.instance();
    protected String connectionURL = "";
    protected List deviceList;
    protected Command cmdBack = new Command("Back", 2, 0);
    protected Command cmdAbort = new Command("Abort scan", 3, 0);
    protected Command cmdRescan = new Command("Rescan devices", 1, 0);
    protected Vector devices;
    protected Vector services;
    protected LocalDevice local;
    protected DiscoveryAgent agent;

    public DeviceList() {
        this.deviceList = new List("Available bluetooth devices", 3);
        this.deviceList.addCommand(this.cmdBack);
        this.deviceList.addCommand(this.cmdRescan);
        this.deviceList.setCommandListener((CommandListener)this);
        this.devices = new Vector();
        this.services = new Vector();
    }

    public void commandAction(Command c, Displayable s) {
        if (c == this.cmdBack) {
            BluetoothMIDlet.instance().show();
        } else if (c == this.cmdRescan) {
            this.findDevices();
        } else if (c == this.cmdAbort) {
            this.console.log("Device scan aborted\n");
            this.agent.cancelInquiry((DiscoveryListener)this);
        } else if (c == List.SELECT_COMMAND) {
            this.findServicesAndConnect((RemoteDevice)this.devices.elementAt(this.deviceList.getSelectedIndex()));
        }
    }

    public void findDevices() {
        this.deviceList.deleteAll();
        this.devices.removeAllElements();
        Display display = Display.getDisplay((MIDlet)BluetoothMIDlet.instance());
        display.setCurrent((Displayable)this.deviceList);
        Gauge inqGauge = new Gauge(null, false, -1, 2);
        Alert scanAlert = new Alert(null, "Searching for Devices...", null, null);
        scanAlert.setTimeout(-2);
        scanAlert.setIndicator(inqGauge);
        scanAlert.addCommand(this.cmdAbort);
        scanAlert.setCommandListener((CommandListener)this);
        display.setCurrent(scanAlert, (Displayable)this.deviceList);
        this.console.log("Searching for devices...\n");
        try {
            this.devices = new Vector();
            this.local = LocalDevice.getLocalDevice();
            this.agent = this.local.getDiscoveryAgent();
            this.agent.startInquiry(10390323, (DiscoveryListener)this);
        }
        catch (Exception e) {
            this.console.log("Error in initiating device scan - " + e.getMessage());
            this.do_alert("Error in initiating device scan.\nCheck if Bluetooth is enabled on your phone.");
        }
    }

    public void findServicesAndConnect(RemoteDevice device) {
        this.console.log("Inquirying services for device " + this.deviceList.getString(this.deviceList.getSelectedIndex()) + "\n");
        Gauge inqGauge = new Gauge(null, false, -1, 2);
        Alert scanAlert = new Alert(null, "Connecting...", null, null);
        scanAlert.setTimeout(-2);
        scanAlert.setIndicator(inqGauge);
        scanAlert.setCommandListener((CommandListener)this);
        Display display = Display.getDisplay((MIDlet)BluetoothMIDlet.instance());
        display.setCurrent(scanAlert, (Displayable)this.deviceList);
        try {
            UUID[] uuids = new UUID[]{new UUID("8140300013dfb0007cf4350b4a2110ee", false)};
            this.agent.searchServices(null, uuids, device, (DiscoveryListener)this);
        }
        catch (Exception e) {
            this.do_alert("Error in initiating services search - " + e.getMessage());
        }
    }

    public void deviceDiscovered(RemoteDevice remoteDevice, DeviceClass deviceClass) {
        this.devices.addElement(remoteDevice);
        this.deviceList.append("Retrieving name... (" + remoteDevice.getBluetoothAddress() + ")", null);
    }

    public void servicesDiscovered(int transID, ServiceRecord[] serviceRecord) {
        for (int x = 0; x < serviceRecord.length; ++x) {
            this.services.addElement(serviceRecord[x]);
        }
    }

    public void inquiryCompleted(int param) {
        Display.getDisplay((MIDlet)BluetoothMIDlet.instance()).setCurrent((Displayable)this.deviceList);
        switch (param) {
            case 0: 
            case 5: {
                if (this.devices.size() > 0) {
                    int i = 0;
                    Enumeration enm = this.devices.elements();
                    while (enm.hasMoreElements()) {
                        RemoteDevice rd = (RemoteDevice)enm.nextElement();
                        try {
                            this.deviceList.set(i, rd.getFriendlyName(true), null);
                        }
                        catch (IOException e) {
                            this.deviceList.set(i, "Unknown device #" + rd.getBluetoothAddress(), null);
                            this.console.log("Could not retrieve name for: " + rd.getBluetoothAddress() + "\n");
                        }
                        ++i;
                    }
                    break;
                }
                this.do_alert("No device found in range");
                break;
            }
            case 7: {
                this.do_alert("Error occured while searching for devices.");
            }
        }
    }

    public void serviceSearchCompleted(int transID, int respCode) {
        Display.getDisplay((MIDlet)BluetoothMIDlet.instance()).setCurrent((Displayable)this.deviceList);
        this.connectionURL = "";
        switch (respCode) {
            case 1: {
                if (this.services.size() > 0) {
                    this.connectionURL = ((ServiceRecord)this.services.firstElement()).getConnectionURL(0, false);
                    this.console.log("Got URL:" + this.connectionURL + "\n");
                    Settings.instance().lastConnection = this.connectionURL;
                    Settings.instance().save();
                    new Communicator().launch(this.connectionURL, (Displayable)this.deviceList);
                    break;
                }
                this.do_alert("Service finder internal error.");
                break;
            }
            case 6: {
                this.do_alert("Device not reachable.");
                break;
            }
            case 3: {
                this.do_alert("Service search error.");
                break;
            }
            case 4: {
                this.do_alert("Brm BT not running on the device. Please download it from brmbt.sf.net and run it on your PC.");
                break;
            }
        }
    }

    public void do_alert(String str) {
        Display display = Display.getDisplay((MIDlet)BluetoothMIDlet.instance());
        Alert a = new Alert("alert", str, null, AlertType.WARNING);
        a.setTimeout(-2);
        display.setCurrent(a, (Displayable)this.deviceList);
    }
}

