/*
 * Decompiled with CFR 0.152.
 */
package brm;

import brm.BluetoothMIDlet;
import brm.Console;
import brm.Settings;
import brm.WrappedTextWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Hashtable;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;

public class Communicator
extends Canvas
implements CommandListener,
Runnable {
    protected String connectionURL;
    protected Displayable prevDisp;
    protected Command cmdBack;
    protected Command cmdChangeProfile;
    protected Command cmdCloseProfileList;
    protected boolean profileLoaded = false;
    protected boolean disconnected = true;
    protected boolean isConnecting = false;
    protected boolean exitTimerThread;
    protected List profileList;
    protected InputStream input;
    protected OutputStream output;
    protected StreamConnection conn;
    protected int threadType;
    protected Thread readerThread = null;
    protected Thread timerThread = null;
    protected long lastActivity;
    protected int layout = 1;
    protected Image gradient;
    protected Hashtable pressedKeys;
    protected int touchedKey;
    protected int[] keys = new int[]{-5, -1, -8, -3, -2, -4, 49, 50, 51, 52, 53, 54, 55, 56, 57, 42, 48, 35};
    protected String[] keyNames = new String[]{"OK", "\u25b2", "C", "\u25c4", "\u25bc", "\u25ba", "1", "2", "3", "4", "5", "6", "7", "8", "9", "*", "0", "#"};
    protected String[] keyLabels = new String[]{"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""};
    protected char[] keyColors = new char[]{'\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'};
    protected char[][] colors = new char[][]{{'\u0000', '\u0000', '\u0000'}, {'\u0000', '\u001e', '\n'}, {'\u0000', '\u001e', '('}, {'(', '\u001e', '\u0000'}, {'(', '(', '\u0000'}};
    protected String field1 = "";
    protected String field2 = "";
    protected int yOffset;
    protected int width;
    protected int height;
    protected int cellSizeX;
    protected int cellSizeY;
    protected int firstKey;
    protected int lastKey;

    public Communicator() {
        this.cmdBack = new Command("Back", 2, 0);
        this.cmdChangeProfile = new Command("Change Profile", 1, 0);
        this.cmdCloseProfileList = new Command("Cancel", 2, 0);
        this.pressedKeys = new Hashtable();
        try {
            this.gradient = Image.createImage((String)"/button_gradient.png");
        }
        catch (IOException e) {
            this.gradient = null;
        }
        this.addCommand(this.cmdBack);
        this.addCommand(this.cmdChangeProfile);
        this.setCommandListener(this);
        this.profileList = new List("Choose a profile", 3);
        this.profileList.addCommand(this.cmdCloseProfileList);
        this.profileList.setCommandListener((CommandListener)this);
    }

    public void commandAction(Command c, Displayable s) {
        if (c == this.cmdBack) {
            this.disconnect();
            this.exitTimerThread = true;
            Display.getDisplay((MIDlet)BluetoothMIDlet.instance()).setCurrent(this.prevDisp);
        } else if (c == this.cmdChangeProfile) {
            this.lastActivity = new Date().getTime();
            this.profileList.deleteAll();
            if (this.sendString("LIST PROFILES")) {
                Display.getDisplay((MIDlet)BluetoothMIDlet.instance()).setCurrent((Displayable)this.profileList);
            }
        } else if (c == this.cmdCloseProfileList) {
            if (!this.profileLoaded) {
                this.exitTimerThread = true;
                this.disconnect();
                Display.getDisplay((MIDlet)BluetoothMIDlet.instance()).setCurrent(this.prevDisp);
            } else {
                Display.getDisplay((MIDlet)BluetoothMIDlet.instance()).setCurrent((Displayable)this);
            }
        } else if (c == List.SELECT_COMMAND) {
            this.lastActivity = new Date().getTime();
            this.sendString("LOAD PROFILE " + this.profileList.getString(this.profileList.getSelectedIndex()));
            Settings.instance().lastProfile = this.profileList.getString(this.profileList.getSelectedIndex());
            Settings.instance().save();
        }
    }

    public void launch(String URL, Displayable prevDisp) {
        this.prevDisp = prevDisp;
        this.connectionURL = URL;
        this.exitTimerThread = false;
        if (!this.connect(true)) {
            return;
        }
        if (Settings.instance().lastProfile.length() != 0) {
            this.sendString("LOAD PROFILE " + Settings.instance().lastProfile);
        } else {
            this.commandAction(this.cmdChangeProfile, (Displayable)this);
        }
        this.threadType = 1;
        this.timerThread = new Thread(this);
        this.timerThread.start();
    }

    protected synchronized boolean connect(boolean exitOnFailure) {
        if (!this.disconnected) {
            return false;
        }
        this.isConnecting = true;
        if (this.isShown()) {
            this.repaint();
        }
        Console.instance().log("Opening data streams...");
        try {
            this.conn = (StreamConnection)Connector.open((String)this.connectionURL);
            this.input = this.conn.openInputStream();
            this.output = this.conn.openOutputStream();
        }
        catch (IOException e) {
            Console.instance().log("Connection failed - " + e.getMessage() + "\n");
            this.disconnect();
            if (exitOnFailure) {
                this.exitTimerThread = true;
                this.do_alert("Could not open connection with the target device.", this.prevDisp);
            } else {
                this.do_alert("Could not open connection with the target device.");
            }
            this.isConnecting = false;
            return false;
        }
        this.disconnected = false;
        this.isConnecting = false;
        if (this.isShown()) {
            this.repaint();
        }
        this.threadType = 0;
        this.readerThread = new Thread(this);
        this.readerThread.start();
        return true;
    }

    protected void disconnect() {
        if (this.disconnected) {
            return;
        }
        this.disconnected = true;
        if (this.isShown()) {
            this.repaint();
        }
        try {
            this.input.close();
            this.output.close();
            this.conn.close();
        }
        catch (IOException e) {
            Console.instance().log("Could not close connection - " + e.getMessage() + "\n");
            return;
        }
        Console.instance().log("Disconnected.\n");
    }

    protected boolean sendString(String s) {
        if (this.disconnected) {
            this.do_alert("Not connected!");
            return false;
        }
        try {
            this.output.write(s.getBytes());
            this.output.flush();
        }
        catch (IOException e) {
            this.do_alert("Failed to send the message!");
            Console.instance().log("Could not send the message - " + e.getMessage() + "\n");
            return false;
        }
        return true;
    }

    public void run() {
        if (this.threadType == 0) {
            Console.instance().log("Created receiver thread\n");
            this.receiverThread();
            Console.instance().log("Exiting receiver thread\n");
        } else if (this.threadType == 1) {
            Console.instance().log("Created timer thread\n");
            this.timerThread();
            Console.instance().log("Exiting timer thread\n");
        }
        this.threadType = -1;
    }

    protected void loadProfiles(String txt) {
        String line = txt.substring(0, txt.indexOf(10) == -1 ? txt.length() : txt.indexOf(10));
        txt = txt.substring(txt.indexOf(10) == -1 ? txt.length() : txt.indexOf(10) + 1);
        while (txt.length() != 0) {
            line = txt.substring(0, txt.indexOf(10) == -1 ? txt.length() : txt.indexOf(10));
            txt = txt.substring(txt.indexOf(10) == -1 ? txt.length() : txt.indexOf(10) + 1);
            if (line.length() == 0) continue;
            this.profileList.append(line, null);
        }
    }

    protected void loadProfile(String profile) {
        for (int i = 0; i < 18; ++i) {
            this.keyLabels[i] = null;
            this.keyColors[i] = '\u0000';
        }
        this.layout = 1;
        String line = profile.substring(0, profile.indexOf(10) == -1 ? profile.length() : profile.indexOf(10));
        profile = profile.substring(profile.indexOf(10) == -1 ? profile.length() : profile.indexOf(10) + 1);
        while (profile.length() != 0) {
            int i;
            line = profile.substring(0, profile.indexOf(10) == -1 ? profile.length() : profile.indexOf(10));
            profile = profile.substring(profile.indexOf(10) == -1 ? profile.length() : profile.indexOf(10) + 1);
            String[] segments = Settings.explodeString(line, "\t");
            if (segments[0].compareTo("Layout:") == 0) {
                this.layout = Integer.parseInt(segments[1]);
                if (this.layout >= 1 && this.layout <= 3) continue;
                this.layout = 1;
                continue;
            }
            if (segments[0].compareTo("Key:") != 0) continue;
            int key = Integer.parseInt(segments[1]);
            for (i = 0; i != this.keys.length && this.keys[i] != key; ++i) {
            }
            if (i == this.keys.length) continue;
            this.keyLabels[i] = segments[2];
            if (segments[3].compareTo("Green") == 0) {
                this.keyColors[i] = '\u0001';
                continue;
            }
            if (segments[3].compareTo("Teal") == 0) {
                this.keyColors[i] = 2;
                continue;
            }
            if (segments[3].compareTo("Orange") == 0) {
                this.keyColors[i] = 3;
                continue;
            }
            if (segments[3].compareTo("Yellow") == 0) {
                this.keyColors[i] = 4;
                continue;
            }
            this.keyColors[i] = '\u0000';
        }
    }

    protected void receiverThread() {
        byte[] b = new byte[4096];
        int bytesRead = 0;
        int dataSize = 0;
        try {
            bytesRead = this.input.read(b, 0, 4);
            Console.instance().log("Bytes read:" + bytesRead + "\n");
            while (bytesRead > 0) {
                int totalRead;
                dataSize = 0;
                dataSize |= b[3] & 0xFF;
                dataSize <<= 8;
                dataSize |= b[2] & 0xFF;
                dataSize <<= 8;
                dataSize |= b[1] & 0xFF;
                dataSize <<= 8;
                Console.instance().log("Data size:" + (dataSize |= b[0] & 0xFF) + "\n");
                for (totalRead = 0; totalRead < dataSize; totalRead += bytesRead) {
                    bytesRead = this.input.read(b, totalRead, dataSize - totalRead > 256 ? 256 : dataSize - totalRead);
                }
                String txt = new String(b, 0, totalRead, "UTF-8");
                Console.instance().log("\n---\n");
                Console.instance().log(txt);
                if (txt.length() >= 8 && txt.substring(0, 8).compareTo("PROFILE:") == 0) {
                    this.loadProfile(txt);
                    Display.getDisplay((MIDlet)BluetoothMIDlet.instance()).setCurrent((Displayable)this);
                    this.setTitle(txt.substring(9, txt.indexOf("\n")).trim());
                    this.profileLoaded = true;
                } else if (txt.length() >= 13 && txt.substring(0, 13).compareTo("PROFILE ERROR") == 0) {
                    this.profileList.deleteAll();
                    this.sendString("LIST PROFILES");
                    this.do_alert("Profile " + Settings.instance().lastProfile + " could not be loaded!", (Displayable)this.profileList);
                } else if (txt.length() >= 13 && txt.substring(0, 13).compareTo("PROFILE LIST:") == 0) {
                    this.loadProfiles(txt);
                } else if (txt.length() >= 7 && txt.substring(0, 7).compareTo("FIELD1:") == 0) {
                    this.field1 = txt.substring(8);
                    if (this.isShown()) {
                        this.repaint();
                    }
                } else if (txt.length() >= 7 && txt.substring(0, 7).compareTo("FIELD2:") == 0) {
                    this.field2 = txt.substring(8);
                    if (this.isShown()) {
                        this.repaint();
                    }
                }
                bytesRead = this.input.read(b, 0, 4);
            }
        }
        catch (IOException e) {
            Console.instance().log("Error reading input stream - " + e.getMessage() + "\n");
        }
        if (!this.disconnected) {
            this.do_alert("Connection interrupted!");
            this.disconnect();
        }
    }

    protected void timerThread() {
        this.lastActivity = new Date().getTime();
        boolean wasShown = true;
        while (!this.exitTimerThread) {
            if (!wasShown && this.isShown() && this.disconnected && (new Date().getTime() - this.lastActivity) / 1000L > (long)Settings.instance().autoDisconnect) {
                this.lastActivity = new Date().getTime();
                if (this.connect(false) && this.sendString("LOAD PROFILE " + Settings.instance().lastProfile)) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            wasShown = this.isShown();
            if (Settings.instance().autoDisconnect > 0 && (new Date().getTime() - this.lastActivity) / 1000L > (long)Settings.instance().autoDisconnect) {
                this.disconnect();
            }
            if (Settings.instance().forceBacklight) {
                Display.getDisplay((MIDlet)BluetoothMIDlet.instance()).flashBacklight(1);
                Display.getDisplay((MIDlet)BluetoothMIDlet.instance()).flashBacklight(0);
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                return;
            }
        }
    }

    protected void setLayoutMetrics() {
        if (this.layout == 1) {
            Font small = Font.getFont((int)64, (int)0, (int)8);
            this.yOffset = small.getHeight() * 2 + 6;
            this.width = this.getWidth();
            this.height = this.getHeight() - this.yOffset;
            this.cellSizeX = this.width / 3;
            this.cellSizeY = this.height / 4;
            this.firstKey = 6;
            this.lastKey = 18;
        } else if (this.layout == 2) {
            this.yOffset = 0;
            this.width = this.getWidth();
            this.height = this.getHeight() - this.yOffset;
            this.cellSizeX = this.width / 3;
            this.cellSizeY = this.height / 6;
            this.firstKey = 0;
            this.lastKey = 18;
        } else {
            this.yOffset = this.getHeight() / 5 * 3;
            this.width = this.getWidth();
            this.height = this.getHeight() - this.yOffset;
            this.cellSizeX = this.width / 3;
            this.cellSizeY = this.getHeight() / 5;
            this.firstKey = 0;
            this.lastKey = 6;
        }
    }

    public void paint(Graphics g) {
        Font small = Font.getFont((int)64, (int)0, (int)8);
        Font large = Font.getFont((int)64, (int)1, (int)16);
        this.setLayoutMetrics();
        if (this.layout == 1 || this.layout == 3) {
            g.setColor(168, 204, 141);
            g.fillRect(3, 3, this.getWidth() - 6, this.yOffset - 3);
            g.setColor(155, 189, 129);
            g.drawRect(2, 2, this.getWidth() - 5, this.yOffset - 2);
            g.setColor(133, 166, 107);
            g.drawRect(1, 1, this.getWidth() - 3, this.yOffset);
            g.setColor(110, 142, 85);
            g.drawRect(0, 0, this.getWidth() - 1, this.yOffset);
        }
        g.setColor(30, 30, 30);
        g.fillRect(0, this.yOffset, this.width, this.height);
        for (int i = this.firstKey; i < this.lastKey; ++i) {
            int pressedOffset;
            int row = (i - this.firstKey) / 3;
            int col = (i - this.firstKey) % 3;
            int n = pressedOffset = this.pressedKeys.get(new Integer(this.keys[i])) != null ? 1 : 0;
            if (pressedOffset != 0) {
                g.setColor(this.colors[this.keyColors[i]][0] + 25, this.colors[this.keyColors[i]][1] + 25, this.colors[this.keyColors[i]][2] + 25);
            } else {
                g.setColor((int)this.colors[this.keyColors[i]][0], (int)this.colors[this.keyColors[i]][1], (int)this.colors[this.keyColors[i]][2]);
            }
            g.fillRect(col * this.cellSizeX + 1, row * this.cellSizeY + 1 + this.yOffset, this.cellSizeX - 1, this.cellSizeY - 1);
            g.setFont(large);
            g.setColor(60, 60, 60);
            g.drawString(this.keyNames[i], (col + 1) * this.cellSizeX - 5, (row + 1) * this.cellSizeY - 3 + this.yOffset + pressedOffset, 40);
            g.setFont(small);
            g.setColor(140, 140, 140);
            if (this.keyLabels[i] != null) {
                WrappedTextWriter.write(g, this.keyLabels[i], col * this.cellSizeX + this.cellSizeX / 2, row * this.cellSizeY + this.cellSizeY / 2 + this.yOffset - small.getHeight() + pressedOffset, this.cellSizeX, small, 1);
            }
            g.drawRegion(this.gradient, 0, (this.gradient.getHeight() - this.cellSizeY) / 2 - pressedOffset, this.cellSizeX, this.cellSizeY, 0, col * this.cellSizeX, row * this.cellSizeY + this.yOffset, 20);
        }
        if (this.layout == 1) {
            g.setFont(small);
            g.setColor(51, 71, 31);
            g.drawString(this.field1, 2, 2, 20);
            g.drawString(this.field2, 2, 4 + small.getHeight(), 20);
        } else if (this.layout == 3) {
            g.setFont(small);
            g.setColor(51, 71, 31);
            WrappedTextWriter.write(g, this.field1 + "\n\n" + this.field2, 2, 2, this.getWidth() - 4, small, 4);
        }
        if (this.disconnected) {
            g.setColor(0, 0, 0);
            g.fillRect(0, this.getHeight() - small.getHeight() - 4, this.getWidth(), this.getHeight());
            g.setFont(small);
            g.setColor(255, 128, 128);
            g.drawString(this.isConnecting ? "connecting..." : "disconnected (press a key)", this.getWidth() / 2, this.getHeight() - 2, 33);
        }
    }

    protected void keyPressed(int keyCode) {
        this.lastActivity = new Date().getTime();
        if (this.disconnected && this.connect(false) && this.sendString("LOAD PROFILE " + Settings.instance().lastProfile)) {
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.pressedKeys.put(new Integer(keyCode), new Integer(1));
        this.repaint();
        this.sendString("DN:" + keyCode);
    }

    protected void keyReleased(int keyCode) {
        this.lastActivity = new Date().getTime();
        this.pressedKeys.remove(new Integer(keyCode));
        this.repaint();
        this.sendString("UP:" + keyCode);
    }

    protected void pointerPressed(int x, int y) {
        this.setLayoutMetrics();
        if (y <= this.yOffset) {
            return;
        }
        this.touchedKey = this.keys[this.firstKey + (x / this.cellSizeX + 3 * ((y - this.yOffset) / this.cellSizeY))];
        this.keyPressed(this.touchedKey);
    }

    protected void pointerReleased(int x, int y) {
        this.keyReleased(this.touchedKey);
    }

    protected void do_alert(String str) {
        Display display = Display.getDisplay((MIDlet)BluetoothMIDlet.instance());
        Alert a = new Alert("alert", str, null, AlertType.WARNING);
        a.setTimeout(-2);
        display.setCurrent(a, (Displayable)this);
    }

    protected void do_alert(String str, Displayable d) {
        Display display = Display.getDisplay((MIDlet)BluetoothMIDlet.instance());
        Alert a = new Alert("alert", str, null, AlertType.WARNING);
        a.setTimeout(-2);
        display.setCurrent(a, d);
    }
}

