/*
 * Decompiled with CFR 0.152.
 */
package brm;

import brm.Communicator;
import brm.DeviceList;
import brm.Options;
import brm.Settings;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;

public class BluetoothMIDlet
extends MIDlet
implements CommandListener {
    private Command cmdExit;
    private Command cmdSelect;
    private Display display;
    private List mainMenu;
    private static BluetoothMIDlet instance = null;

    public BluetoothMIDlet() {
        if (instance == null) {
            instance = this;
        }
        this.display = Display.getDisplay((MIDlet)this);
        this.cmdExit = new Command("Exit", 7, 0);
        this.cmdSelect = new Command("Select", 1, 0);
    }

    public static BluetoothMIDlet instance() {
        return instance;
    }

    protected void populateMenu() {
        this.mainMenu.deleteAll();
        if (Settings.instance().lastConnection.length() > 0) {
            this.mainMenu.append("Use last connection", null);
        }
        this.mainMenu.append("Connect to a device", null);
        this.mainMenu.append("Options", null);
        this.mainMenu.append("Exit", null);
    }

    public void startApp() {
        this.mainMenu = new List("Brm BT Remote", 3);
        this.populateMenu();
        this.mainMenu.addCommand(this.cmdExit);
        this.mainMenu.addCommand(this.cmdSelect);
        this.mainMenu.setCommandListener((CommandListener)this);
        this.display.setCurrent((Displayable)this.mainMenu);
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean unconditional) {
    }

    public void commandAction(Command c, Displayable s) {
        if (c == this.cmdSelect || c == List.SELECT_COMMAND) {
            boolean hasLastConnection = this.mainMenu.getString(0).compareTo("Use last connection") == 0;
            int index = this.mainMenu.getSelectedIndex();
            if (index == 0 && hasLastConnection) {
                new Communicator().launch(Settings.instance().lastConnection, (Displayable)this.mainMenu);
            } else if (index == 0 && !hasLastConnection || index == 1 && hasLastConnection) {
                DeviceList devList = new DeviceList();
                devList.findDevices();
            } else if (index == 1 && !hasLastConnection || index == 2 && hasLastConnection) {
                new Options().show();
            } else {
                if (index != 2 || !hasLastConnection) {
                    // empty if block
                }
                if (index != 3 || hasLastConnection) {
                    // empty if block
                }
                this.destroyApp(false);
                this.notifyDestroyed();
            }
        } else if (c == this.cmdExit) {
            this.destroyApp(false);
            this.notifyDestroyed();
        }
    }

    public void show() {
        if (this.mainMenu.getString(0).compareTo("Use last connection") != 0 && Settings.instance().lastConnection.length() > 0) {
            this.populateMenu();
        }
        this.display.setCurrent((Displayable)this.mainMenu);
    }
}

